/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Windows.Forms;
using System.Text;
using System.Globalization;

using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Ocl.Support;
using Borland.Eco.Exceptions;
using Borland.Eco.Windows.Forms;
using Borland.Eco.Support;

namespace Borland.Eco.Handles
{
	/// <summary>
	/// Summary description for OclEditor.
	/// </summary>
	public class OclEditor: System.Windows.Forms.Form
	{
		private const char AttributePrefix = 'A';
		private const char RolePrefix = 'B';
		private const char OperationPrefix = 'C';
		private const char ClassPrefix = 'D';
		private const char UnknownPrefix = 'E';

		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Panel panel3;
		private System.Windows.Forms.ListBox SelectBox;
		public System.Windows.Forms.Button OK;
		public System.Windows.Forms.Button Cancel;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel panel6;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Panel panel4;
		public System.Windows.Forms.TextBox EditMemo;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.Panel panel5;
		public System.Windows.Forms.Button Clear;
		public System.Windows.Forms.Button RemoveLast;
		private System.Windows.Forms.ImageList imageList1;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.TreeView SelectTree;

		private TreeNode classNode;
		private TreeNode triggerNode;
		private TreeNode triggerQueryNode;
		private TreeNode attributeNode;
		private TreeNode roleNode;
		private TreeNode methodNode;
		private TreeNode oclOperationNode;
		private TreeNode variableNode;
		private static bool treeviewVisible = true;
		private System.Windows.Forms.RichTextBox richTextBox1;
		private System.Windows.Forms.ToolBar toolBar1;
		private System.Windows.Forms.ToolBarButton tbbList;
		private System.Windows.Forms.ToolBarButton tbbHierarchical;
		private System.Windows.Forms.ToolBarButton tbbShowTypes;
		private System.Windows.Forms.ToolBarButton tbbShowDefiningClass;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage tabParserMessage;
		private System.Windows.Forms.TabPage tabOclHelp;
		private System.Windows.Forms.TextBox tbxNodeInfo;
		private System.Windows.Forms.TabPage tabOclInfo;
		private System.Windows.Forms.TextBox textBox1;

		private static TreeNode NewNode(string text, string expr)
		{
			return NewNode(text, expr, false);
		}

		private class ListItem: IComparable
		{
			public string Text;
			public string Expr;
			public char Prefix;
			public override string ToString() { return Text; }
			int IComparable.CompareTo(object obj)
			{
				ListItem listItem = obj as ListItem;
				int res = Prefix.CompareTo(listItem.Prefix);
				if (res == 0)
					res = Text.CompareTo(listItem.Text);
				return res;
			}
		}

		private static object NewItem(char prefix, string text, string expr)
		{
			ListItem item = new ListItem();
			item.Prefix = prefix;
			item.Text = text;
			item.Expr = expr;
			return item;
		}

		private static TreeNode NewNode(string text, string expr, bool inactive)
		{
			TreeNode res = new TreeNode(text);
			if (inactive)
			{
				res.Tag = string.Empty;
				res.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
			}
			else
				res.Tag = expr;
			return res;
		}

		private OclEditor()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			foreach (TreeNode node in SelectTree.Nodes)
			{
				if (node.Text == FormsStringRes.sNodeNameClasses)
				{
					classNode = node;
					classNode.Tag = 0; // used for sorting
				}
				if (node.Text == FormsStringRes.sNodeNameAttributes)
				{
					attributeNode = node;
					attributeNode.Tag = 1; // used for sorting
				}
				if (node.Text == FormsStringRes.sNodeNameRoles)
				{
					roleNode = node;
					roleNode.Tag = 2; // used for sorting
				}
				if (node.Text == FormsStringRes.sNodeNameMethods)
				{
					methodNode = node;
					methodNode.Tag = 3; // used for sorting
				}
				if (node.Text == FormsStringRes.sNodeNameOcloperations)
				{
					oclOperationNode = node;
					oclOperationNode.Tag = 4; // used for sorting
				}
				if (node.Text == FormsStringRes.sNodeNameVariables)
				{
					variableNode = node;
					variableNode.Tag = 5; // used for sorting
				}

				if (node.Text == FormsStringRes.sNodeNameTriggers)
				{
					triggerNode = node;
					triggerNode.Tag = 6; // used for sorting
				}

				if (node.Text == FormsStringRes.sNodeNameTriggerqueries)
				{
					triggerQueryNode = node;
					triggerQueryNode.Tag = 7; // used for sorting
				}
			}

			SelectTree.Nodes.Clear();

			SelectBox.Height = SelectTree.Bottom - SelectBox.Top;
			SelectTree.Top = SelectBox.Top;
			SelectTree.Height = SelectBox.Height;
			EnableTreeView(treeviewVisible);

			EditMemo.Focus();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(OclEditor));
			this.panel2 = new System.Windows.Forms.Panel();
			this.Cancel = new System.Windows.Forms.Button();
			this.OK = new System.Windows.Forms.Button();
			this.panel3 = new System.Windows.Forms.Panel();
			this.toolBar1 = new System.Windows.Forms.ToolBar();
			this.tbbList = new System.Windows.Forms.ToolBarButton();
			this.tbbHierarchical = new System.Windows.Forms.ToolBarButton();
			this.tbbShowTypes = new System.Windows.Forms.ToolBarButton();
			this.tbbShowDefiningClass = new System.Windows.Forms.ToolBarButton();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.SelectTree = new System.Windows.Forms.TreeView();
			this.SelectBox = new System.Windows.Forms.ListBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.panel6 = new System.Windows.Forms.Panel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel4 = new System.Windows.Forms.Panel();
			this.EditMemo = new System.Windows.Forms.TextBox();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.panel5 = new System.Windows.Forms.Panel();
			this.Clear = new System.Windows.Forms.Button();
			this.RemoveLast = new System.Windows.Forms.Button();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.tabParserMessage = new System.Windows.Forms.TabPage();
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.tabOclHelp = new System.Windows.Forms.TabPage();
			this.tbxNodeInfo = new System.Windows.Forms.TextBox();
			this.tabOclInfo = new System.Windows.Forms.TabPage();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.panel2.SuspendLayout();
			this.panel3.SuspendLayout();
			this.panel6.SuspendLayout();
			this.panel1.SuspendLayout();
			this.panel4.SuspendLayout();
			this.panel5.SuspendLayout();
			this.tabControl1.SuspendLayout();
			this.tabParserMessage.SuspendLayout();
			this.tabOclHelp.SuspendLayout();
			this.tabOclInfo.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel2
			// 
			this.panel2.AccessibleDescription = resources.GetString("panel2.AccessibleDescription");
			this.panel2.AccessibleName = resources.GetString("panel2.AccessibleName");
			this.panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel2.Anchor")));
			this.panel2.AutoScroll = ((bool)(resources.GetObject("panel2.AutoScroll")));
			this.panel2.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel2.AutoScrollMargin")));
			this.panel2.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel2.AutoScrollMinSize")));
			this.panel2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel2.BackgroundImage")));
			this.panel2.Controls.Add(this.Cancel);
			this.panel2.Controls.Add(this.OK);
			this.panel2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel2.Dock")));
			this.panel2.Enabled = ((bool)(resources.GetObject("panel2.Enabled")));
			this.panel2.Font = ((System.Drawing.Font)(resources.GetObject("panel2.Font")));
			this.panel2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel2.ImeMode")));
			this.panel2.Location = ((System.Drawing.Point)(resources.GetObject("panel2.Location")));
			this.panel2.Name = "panel2";
			this.panel2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel2.RightToLeft")));
			this.panel2.Size = ((System.Drawing.Size)(resources.GetObject("panel2.Size")));
			this.panel2.TabIndex = ((int)(resources.GetObject("panel2.TabIndex")));
			this.panel2.Text = resources.GetString("panel2.Text");
			this.panel2.Visible = ((bool)(resources.GetObject("panel2.Visible")));
			// 
			// Cancel
			// 
			this.Cancel.AccessibleDescription = resources.GetString("Cancel.AccessibleDescription");
			this.Cancel.AccessibleName = resources.GetString("Cancel.AccessibleName");
			this.Cancel.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("Cancel.Anchor")));
			this.Cancel.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("Cancel.BackgroundImage")));
			this.Cancel.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("Cancel.Dock")));
			this.Cancel.Enabled = ((bool)(resources.GetObject("Cancel.Enabled")));
			this.Cancel.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("Cancel.FlatStyle")));
			this.Cancel.Font = ((System.Drawing.Font)(resources.GetObject("Cancel.Font")));
			this.Cancel.Image = ((System.Drawing.Image)(resources.GetObject("Cancel.Image")));
			this.Cancel.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Cancel.ImageAlign")));
			this.Cancel.ImageIndex = ((int)(resources.GetObject("Cancel.ImageIndex")));
			this.Cancel.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("Cancel.ImeMode")));
			this.Cancel.Location = ((System.Drawing.Point)(resources.GetObject("Cancel.Location")));
			this.Cancel.Name = "Cancel";
			this.Cancel.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("Cancel.RightToLeft")));
			this.Cancel.Size = ((System.Drawing.Size)(resources.GetObject("Cancel.Size")));
			this.Cancel.TabIndex = ((int)(resources.GetObject("Cancel.TabIndex")));
			this.Cancel.Text = resources.GetString("Cancel.Text");
			this.Cancel.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Cancel.TextAlign")));
			this.Cancel.Visible = ((bool)(resources.GetObject("Cancel.Visible")));
			this.Cancel.Click += new System.EventHandler(this.Cancel_Click);
			// 
			// OK
			// 
			this.OK.AccessibleDescription = resources.GetString("OK.AccessibleDescription");
			this.OK.AccessibleName = resources.GetString("OK.AccessibleName");
			this.OK.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("OK.Anchor")));
			this.OK.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("OK.BackgroundImage")));
			this.OK.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("OK.Dock")));
			this.OK.Enabled = ((bool)(resources.GetObject("OK.Enabled")));
			this.OK.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("OK.FlatStyle")));
			this.OK.Font = ((System.Drawing.Font)(resources.GetObject("OK.Font")));
			this.OK.Image = ((System.Drawing.Image)(resources.GetObject("OK.Image")));
			this.OK.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("OK.ImageAlign")));
			this.OK.ImageIndex = ((int)(resources.GetObject("OK.ImageIndex")));
			this.OK.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("OK.ImeMode")));
			this.OK.Location = ((System.Drawing.Point)(resources.GetObject("OK.Location")));
			this.OK.Name = "OK";
			this.OK.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("OK.RightToLeft")));
			this.OK.Size = ((System.Drawing.Size)(resources.GetObject("OK.Size")));
			this.OK.TabIndex = ((int)(resources.GetObject("OK.TabIndex")));
			this.OK.Text = resources.GetString("OK.Text");
			this.OK.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("OK.TextAlign")));
			this.OK.Visible = ((bool)(resources.GetObject("OK.Visible")));
			this.OK.Click += new System.EventHandler(this.OK_Click);
			// 
			// panel3
			// 
			this.panel3.AccessibleDescription = resources.GetString("panel3.AccessibleDescription");
			this.panel3.AccessibleName = resources.GetString("panel3.AccessibleName");
			this.panel3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel3.Anchor")));
			this.panel3.AutoScroll = ((bool)(resources.GetObject("panel3.AutoScroll")));
			this.panel3.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel3.AutoScrollMargin")));
			this.panel3.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel3.AutoScrollMinSize")));
			this.panel3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel3.BackgroundImage")));
			this.panel3.Controls.Add(this.toolBar1);
			this.panel3.Controls.Add(this.SelectTree);
			this.panel3.Controls.Add(this.SelectBox);
			this.panel3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel3.Dock")));
			this.panel3.Enabled = ((bool)(resources.GetObject("panel3.Enabled")));
			this.panel3.Font = ((System.Drawing.Font)(resources.GetObject("panel3.Font")));
			this.panel3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel3.ImeMode")));
			this.panel3.Location = ((System.Drawing.Point)(resources.GetObject("panel3.Location")));
			this.panel3.Name = "panel3";
			this.panel3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel3.RightToLeft")));
			this.panel3.Size = ((System.Drawing.Size)(resources.GetObject("panel3.Size")));
			this.panel3.TabIndex = ((int)(resources.GetObject("panel3.TabIndex")));
			this.panel3.Text = resources.GetString("panel3.Text");
			this.panel3.Visible = ((bool)(resources.GetObject("panel3.Visible")));
			this.panel3.Resize += new System.EventHandler(this.panel3_Resize);
			// 
			// toolBar1
			// 
			this.toolBar1.AccessibleDescription = resources.GetString("toolBar1.AccessibleDescription");
			this.toolBar1.AccessibleName = resources.GetString("toolBar1.AccessibleName");
			this.toolBar1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("toolBar1.Anchor")));
			this.toolBar1.Appearance = ((System.Windows.Forms.ToolBarAppearance)(resources.GetObject("toolBar1.Appearance")));
			this.toolBar1.AutoSize = ((bool)(resources.GetObject("toolBar1.AutoSize")));
			this.toolBar1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("toolBar1.BackgroundImage")));
			this.toolBar1.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
						this.tbbList,
						this.tbbHierarchical,
						this.tbbShowTypes,
						this.tbbShowDefiningClass});
			this.toolBar1.ButtonSize = ((System.Drawing.Size)(resources.GetObject("toolBar1.ButtonSize")));
			this.toolBar1.Divider = false;
			this.toolBar1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("toolBar1.Dock")));
			this.toolBar1.DropDownArrows = ((bool)(resources.GetObject("toolBar1.DropDownArrows")));
			this.toolBar1.Enabled = ((bool)(resources.GetObject("toolBar1.Enabled")));
			this.toolBar1.Font = ((System.Drawing.Font)(resources.GetObject("toolBar1.Font")));
			this.toolBar1.ImageList = this.imageList1;
			this.toolBar1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("toolBar1.ImeMode")));
			this.toolBar1.Location = ((System.Drawing.Point)(resources.GetObject("toolBar1.Location")));
			this.toolBar1.Name = "toolBar1";
			this.toolBar1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("toolBar1.RightToLeft")));
			this.toolBar1.ShowToolTips = ((bool)(resources.GetObject("toolBar1.ShowToolTips")));
			this.toolBar1.Size = ((System.Drawing.Size)(resources.GetObject("toolBar1.Size")));
			this.toolBar1.TabIndex = ((int)(resources.GetObject("toolBar1.TabIndex")));
			this.toolBar1.TextAlign = ((System.Windows.Forms.ToolBarTextAlign)(resources.GetObject("toolBar1.TextAlign")));
			this.toolBar1.Visible = ((bool)(resources.GetObject("toolBar1.Visible")));
			this.toolBar1.Wrappable = ((bool)(resources.GetObject("toolBar1.Wrappable")));
			this.toolBar1.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar1_ButtonClick);
			// 
			// tbbList
			// 
			this.tbbList.Enabled = ((bool)(resources.GetObject("tbbList.Enabled")));
			this.tbbList.ImageIndex = ((int)(resources.GetObject("tbbList.ImageIndex")));
			this.tbbList.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbList.Text = resources.GetString("tbbList.Text");
			this.tbbList.ToolTipText = resources.GetString("tbbList.ToolTipText");
			this.tbbList.Visible = ((bool)(resources.GetObject("tbbList.Visible")));
			// 
			// tbbHierarchical
			// 
			this.tbbHierarchical.Enabled = ((bool)(resources.GetObject("tbbHierarchical.Enabled")));
			this.tbbHierarchical.ImageIndex = ((int)(resources.GetObject("tbbHierarchical.ImageIndex")));
			this.tbbHierarchical.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbHierarchical.Text = resources.GetString("tbbHierarchical.Text");
			this.tbbHierarchical.ToolTipText = resources.GetString("tbbHierarchical.ToolTipText");
			this.tbbHierarchical.Visible = ((bool)(resources.GetObject("tbbHierarchical.Visible")));
			// 
			// tbbShowTypes
			// 
			this.tbbShowTypes.Enabled = ((bool)(resources.GetObject("tbbShowTypes.Enabled")));
			this.tbbShowTypes.ImageIndex = ((int)(resources.GetObject("tbbShowTypes.ImageIndex")));
			this.tbbShowTypes.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbShowTypes.Text = resources.GetString("tbbShowTypes.Text");
			this.tbbShowTypes.ToolTipText = resources.GetString("tbbShowTypes.ToolTipText");
			this.tbbShowTypes.Visible = ((bool)(resources.GetObject("tbbShowTypes.Visible")));
			// 
			// tbbShowDefiningClass
			// 
			this.tbbShowDefiningClass.Enabled = ((bool)(resources.GetObject("tbbShowDefiningClass.Enabled")));
			this.tbbShowDefiningClass.ImageIndex = ((int)(resources.GetObject("tbbShowDefiningClass.ImageIndex")));
			this.tbbShowDefiningClass.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbShowDefiningClass.Text = resources.GetString("tbbShowDefiningClass.Text");
			this.tbbShowDefiningClass.ToolTipText = resources.GetString("tbbShowDefiningClass.ToolTipText");
			this.tbbShowDefiningClass.Visible = ((bool)(resources.GetObject("tbbShowDefiningClass.Visible")));
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = ((System.Drawing.Size)(resources.GetObject("imageList1.ImageSize")));
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.White;
			// 
			// SelectTree
			// 
			this.SelectTree.AccessibleDescription = resources.GetString("SelectTree.AccessibleDescription");
			this.SelectTree.AccessibleName = resources.GetString("SelectTree.AccessibleName");
			this.SelectTree.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("SelectTree.Anchor")));
			this.SelectTree.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("SelectTree.BackgroundImage")));
			this.SelectTree.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("SelectTree.Dock")));
			this.SelectTree.Enabled = ((bool)(resources.GetObject("SelectTree.Enabled")));
			this.SelectTree.Font = ((System.Drawing.Font)(resources.GetObject("SelectTree.Font")));
			this.SelectTree.HideSelection = false;
			this.SelectTree.ImageIndex = ((int)(resources.GetObject("SelectTree.ImageIndex")));
			this.SelectTree.ImageList = this.imageList1;
			this.SelectTree.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("SelectTree.ImeMode")));
			this.SelectTree.Indent = ((int)(resources.GetObject("SelectTree.Indent")));
			this.SelectTree.ItemHeight = ((int)(resources.GetObject("SelectTree.ItemHeight")));
			this.SelectTree.Location = ((System.Drawing.Point)(resources.GetObject("SelectTree.Location")));
			this.SelectTree.Name = "SelectTree";
			this.SelectTree.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes1"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes2"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes3"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes4"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes5"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes6"))),
						((System.Windows.Forms.TreeNode)(resources.GetObject("SelectTree.Nodes7")))});
			this.SelectTree.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("SelectTree.RightToLeft")));
			this.SelectTree.SelectedImageIndex = ((int)(resources.GetObject("SelectTree.SelectedImageIndex")));
			this.SelectTree.Size = ((System.Drawing.Size)(resources.GetObject("SelectTree.Size")));
			this.SelectTree.TabIndex = ((int)(resources.GetObject("SelectTree.TabIndex")));
			this.SelectTree.Text = resources.GetString("SelectTree.Text");
			this.SelectTree.Visible = ((bool)(resources.GetObject("SelectTree.Visible")));
			this.SelectTree.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.SelectTree_KeyPress);
			this.SelectTree.DoubleClick += new System.EventHandler(this.SelectTree_DoubleClick);
			this.SelectTree.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.SelectTree_AfterSelect);
			// 
			// SelectBox
			// 
			this.SelectBox.AccessibleDescription = resources.GetString("SelectBox.AccessibleDescription");
			this.SelectBox.AccessibleName = resources.GetString("SelectBox.AccessibleName");
			this.SelectBox.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("SelectBox.Anchor")));
			this.SelectBox.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("SelectBox.BackgroundImage")));
			this.SelectBox.ColumnWidth = ((int)(resources.GetObject("SelectBox.ColumnWidth")));
			this.SelectBox.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("SelectBox.Dock")));
			this.SelectBox.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
			this.SelectBox.Enabled = ((bool)(resources.GetObject("SelectBox.Enabled")));
			this.SelectBox.Font = ((System.Drawing.Font)(resources.GetObject("SelectBox.Font")));
			this.SelectBox.HorizontalExtent = ((int)(resources.GetObject("SelectBox.HorizontalExtent")));
			this.SelectBox.HorizontalScrollbar = ((bool)(resources.GetObject("SelectBox.HorizontalScrollbar")));
			this.SelectBox.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("SelectBox.ImeMode")));
			this.SelectBox.IntegralHeight = ((bool)(resources.GetObject("SelectBox.IntegralHeight")));
			this.SelectBox.ItemHeight = ((int)(resources.GetObject("SelectBox.ItemHeight")));
			this.SelectBox.Location = ((System.Drawing.Point)(resources.GetObject("SelectBox.Location")));
			this.SelectBox.Name = "SelectBox";
			this.SelectBox.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("SelectBox.RightToLeft")));
			this.SelectBox.ScrollAlwaysVisible = ((bool)(resources.GetObject("SelectBox.ScrollAlwaysVisible")));
			this.SelectBox.Size = ((System.Drawing.Size)(resources.GetObject("SelectBox.Size")));
			this.SelectBox.TabIndex = ((int)(resources.GetObject("SelectBox.TabIndex")));
			this.SelectBox.Visible = ((bool)(resources.GetObject("SelectBox.Visible")));
			this.SelectBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.SelectBox_KeyPress);
			this.SelectBox.DoubleClick += new System.EventHandler(this.SelectBox_DoubleClick);
			this.SelectBox.MouseMove += new System.Windows.Forms.MouseEventHandler(this.SelectBox_MouseMove);
			this.SelectBox.DrawItem += new System.Windows.Forms.DrawItemEventHandler(this.SelectBox_DrawItem);
			this.SelectBox.SelectedIndexChanged += new System.EventHandler(this.SelectBox_SelectedIndexChanged);
			// 
			// splitter1
			// 
			this.splitter1.AccessibleDescription = resources.GetString("splitter1.AccessibleDescription");
			this.splitter1.AccessibleName = resources.GetString("splitter1.AccessibleName");
			this.splitter1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("splitter1.Anchor")));
			this.splitter1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("splitter1.BackgroundImage")));
			this.splitter1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("splitter1.Dock")));
			this.splitter1.Enabled = ((bool)(resources.GetObject("splitter1.Enabled")));
			this.splitter1.Font = ((System.Drawing.Font)(resources.GetObject("splitter1.Font")));
			this.splitter1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("splitter1.ImeMode")));
			this.splitter1.Location = ((System.Drawing.Point)(resources.GetObject("splitter1.Location")));
			this.splitter1.MinExtra = ((int)(resources.GetObject("splitter1.MinExtra")));
			this.splitter1.MinSize = ((int)(resources.GetObject("splitter1.MinSize")));
			this.splitter1.Name = "splitter1";
			this.splitter1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("splitter1.RightToLeft")));
			this.splitter1.Size = ((System.Drawing.Size)(resources.GetObject("splitter1.Size")));
			this.splitter1.TabIndex = ((int)(resources.GetObject("splitter1.TabIndex")));
			this.splitter1.TabStop = false;
			this.splitter1.Visible = ((bool)(resources.GetObject("splitter1.Visible")));
			this.splitter1.SplitterMoved += new System.Windows.Forms.SplitterEventHandler(this.splitter1_SplitterMoved);
			// 
			// panel6
			// 
			this.panel6.AccessibleDescription = resources.GetString("panel6.AccessibleDescription");
			this.panel6.AccessibleName = resources.GetString("panel6.AccessibleName");
			this.panel6.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel6.Anchor")));
			this.panel6.AutoScroll = ((bool)(resources.GetObject("panel6.AutoScroll")));
			this.panel6.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel6.AutoScrollMargin")));
			this.panel6.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel6.AutoScrollMinSize")));
			this.panel6.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel6.BackgroundImage")));
			this.panel6.Controls.Add(this.panel1);
			this.panel6.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel6.Dock")));
			this.panel6.Enabled = ((bool)(resources.GetObject("panel6.Enabled")));
			this.panel6.Font = ((System.Drawing.Font)(resources.GetObject("panel6.Font")));
			this.panel6.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel6.ImeMode")));
			this.panel6.Location = ((System.Drawing.Point)(resources.GetObject("panel6.Location")));
			this.panel6.Name = "panel6";
			this.panel6.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel6.RightToLeft")));
			this.panel6.Size = ((System.Drawing.Size)(resources.GetObject("panel6.Size")));
			this.panel6.TabIndex = ((int)(resources.GetObject("panel6.TabIndex")));
			this.panel6.Text = resources.GetString("panel6.Text");
			this.panel6.Visible = ((bool)(resources.GetObject("panel6.Visible")));
			// 
			// panel1
			// 
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.panel4);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			// 
			// panel4
			// 
			this.panel4.AccessibleDescription = resources.GetString("panel4.AccessibleDescription");
			this.panel4.AccessibleName = resources.GetString("panel4.AccessibleName");
			this.panel4.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel4.Anchor")));
			this.panel4.AutoScroll = ((bool)(resources.GetObject("panel4.AutoScroll")));
			this.panel4.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel4.AutoScrollMargin")));
			this.panel4.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel4.AutoScrollMinSize")));
			this.panel4.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel4.BackgroundImage")));
			this.panel4.Controls.Add(this.EditMemo);
			this.panel4.Controls.Add(this.splitter2);
			this.panel4.Controls.Add(this.panel5);
			this.panel4.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel4.Dock")));
			this.panel4.Enabled = ((bool)(resources.GetObject("panel4.Enabled")));
			this.panel4.Font = ((System.Drawing.Font)(resources.GetObject("panel4.Font")));
			this.panel4.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel4.ImeMode")));
			this.panel4.Location = ((System.Drawing.Point)(resources.GetObject("panel4.Location")));
			this.panel4.Name = "panel4";
			this.panel4.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel4.RightToLeft")));
			this.panel4.Size = ((System.Drawing.Size)(resources.GetObject("panel4.Size")));
			this.panel4.TabIndex = ((int)(resources.GetObject("panel4.TabIndex")));
			this.panel4.Text = resources.GetString("panel4.Text");
			this.panel4.Visible = ((bool)(resources.GetObject("panel4.Visible")));
			// 
			// EditMemo
			// 
			this.EditMemo.AcceptsReturn = true;
			this.EditMemo.AccessibleDescription = resources.GetString("EditMemo.AccessibleDescription");
			this.EditMemo.AccessibleName = resources.GetString("EditMemo.AccessibleName");
			this.EditMemo.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("EditMemo.Anchor")));
			this.EditMemo.AutoSize = ((bool)(resources.GetObject("EditMemo.AutoSize")));
			this.EditMemo.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("EditMemo.BackgroundImage")));
			this.EditMemo.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("EditMemo.Dock")));
			this.EditMemo.Enabled = ((bool)(resources.GetObject("EditMemo.Enabled")));
			this.EditMemo.Font = ((System.Drawing.Font)(resources.GetObject("EditMemo.Font")));
			this.EditMemo.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("EditMemo.ImeMode")));
			this.EditMemo.Location = ((System.Drawing.Point)(resources.GetObject("EditMemo.Location")));
			this.EditMemo.MaxLength = ((int)(resources.GetObject("EditMemo.MaxLength")));
			this.EditMemo.Multiline = ((bool)(resources.GetObject("EditMemo.Multiline")));
			this.EditMemo.Name = "EditMemo";
			this.EditMemo.PasswordChar = ((char)(resources.GetObject("EditMemo.PasswordChar")));
			this.EditMemo.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("EditMemo.RightToLeft")));
			this.EditMemo.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("EditMemo.ScrollBars")));
			this.EditMemo.Size = ((System.Drawing.Size)(resources.GetObject("EditMemo.Size")));
			this.EditMemo.TabIndex = ((int)(resources.GetObject("EditMemo.TabIndex")));
			this.EditMemo.Text = resources.GetString("EditMemo.Text");
			this.EditMemo.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("EditMemo.TextAlign")));
			this.EditMemo.Visible = ((bool)(resources.GetObject("EditMemo.Visible")));
			this.EditMemo.WordWrap = ((bool)(resources.GetObject("EditMemo.WordWrap")));
			this.EditMemo.MouseDown += new System.Windows.Forms.MouseEventHandler(this.EditMemo_MouseDown);
			this.EditMemo.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.EditMemo_KeyPress);
			this.EditMemo.TextChanged += new System.EventHandler(this.EditMemo_TextChanged);
			this.EditMemo.KeyUp += new System.Windows.Forms.KeyEventHandler(this.EditMemo_KeyUp);
			this.EditMemo.Enter += new System.EventHandler(this.EditMemo_Enter);
			// 
			// splitter2
			// 
			this.splitter2.AccessibleDescription = resources.GetString("splitter2.AccessibleDescription");
			this.splitter2.AccessibleName = resources.GetString("splitter2.AccessibleName");
			this.splitter2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("splitter2.Anchor")));
			this.splitter2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("splitter2.BackgroundImage")));
			this.splitter2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("splitter2.Dock")));
			this.splitter2.Enabled = ((bool)(resources.GetObject("splitter2.Enabled")));
			this.splitter2.Font = ((System.Drawing.Font)(resources.GetObject("splitter2.Font")));
			this.splitter2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("splitter2.ImeMode")));
			this.splitter2.Location = ((System.Drawing.Point)(resources.GetObject("splitter2.Location")));
			this.splitter2.MinExtra = ((int)(resources.GetObject("splitter2.MinExtra")));
			this.splitter2.MinSize = ((int)(resources.GetObject("splitter2.MinSize")));
			this.splitter2.Name = "splitter2";
			this.splitter2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("splitter2.RightToLeft")));
			this.splitter2.Size = ((System.Drawing.Size)(resources.GetObject("splitter2.Size")));
			this.splitter2.TabIndex = ((int)(resources.GetObject("splitter2.TabIndex")));
			this.splitter2.TabStop = false;
			this.splitter2.Visible = ((bool)(resources.GetObject("splitter2.Visible")));
			this.splitter2.SplitterMoved += new System.Windows.Forms.SplitterEventHandler(this.splitter2_SplitterMoved);
			// 
			// panel5
			// 
			this.panel5.AccessibleDescription = resources.GetString("panel5.AccessibleDescription");
			this.panel5.AccessibleName = resources.GetString("panel5.AccessibleName");
			this.panel5.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel5.Anchor")));
			this.panel5.AutoScroll = ((bool)(resources.GetObject("panel5.AutoScroll")));
			this.panel5.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel5.AutoScrollMargin")));
			this.panel5.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel5.AutoScrollMinSize")));
			this.panel5.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel5.BackgroundImage")));
			this.panel5.Controls.Add(this.Clear);
			this.panel5.Controls.Add(this.RemoveLast);
			this.panel5.Controls.Add(this.tabControl1);
			this.panel5.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel5.Dock")));
			this.panel5.Enabled = ((bool)(resources.GetObject("panel5.Enabled")));
			this.panel5.Font = ((System.Drawing.Font)(resources.GetObject("panel5.Font")));
			this.panel5.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel5.ImeMode")));
			this.panel5.Location = ((System.Drawing.Point)(resources.GetObject("panel5.Location")));
			this.panel5.Name = "panel5";
			this.panel5.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel5.RightToLeft")));
			this.panel5.Size = ((System.Drawing.Size)(resources.GetObject("panel5.Size")));
			this.panel5.TabIndex = ((int)(resources.GetObject("panel5.TabIndex")));
			this.panel5.Text = resources.GetString("panel5.Text");
			this.panel5.Visible = ((bool)(resources.GetObject("panel5.Visible")));
			// 
			// Clear
			// 
			this.Clear.AccessibleDescription = resources.GetString("Clear.AccessibleDescription");
			this.Clear.AccessibleName = resources.GetString("Clear.AccessibleName");
			this.Clear.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("Clear.Anchor")));
			this.Clear.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("Clear.BackgroundImage")));
			this.Clear.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("Clear.Dock")));
			this.Clear.Enabled = ((bool)(resources.GetObject("Clear.Enabled")));
			this.Clear.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("Clear.FlatStyle")));
			this.Clear.Font = ((System.Drawing.Font)(resources.GetObject("Clear.Font")));
			this.Clear.Image = ((System.Drawing.Image)(resources.GetObject("Clear.Image")));
			this.Clear.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Clear.ImageAlign")));
			this.Clear.ImageIndex = ((int)(resources.GetObject("Clear.ImageIndex")));
			this.Clear.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("Clear.ImeMode")));
			this.Clear.Location = ((System.Drawing.Point)(resources.GetObject("Clear.Location")));
			this.Clear.Name = "Clear";
			this.Clear.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("Clear.RightToLeft")));
			this.Clear.Size = ((System.Drawing.Size)(resources.GetObject("Clear.Size")));
			this.Clear.TabIndex = ((int)(resources.GetObject("Clear.TabIndex")));
			this.Clear.Text = resources.GetString("Clear.Text");
			this.Clear.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Clear.TextAlign")));
			this.Clear.Visible = ((bool)(resources.GetObject("Clear.Visible")));
			this.Clear.Click += new System.EventHandler(this.Clear_Click);
			// 
			// RemoveLast
			// 
			this.RemoveLast.AccessibleDescription = resources.GetString("RemoveLast.AccessibleDescription");
			this.RemoveLast.AccessibleName = resources.GetString("RemoveLast.AccessibleName");
			this.RemoveLast.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("RemoveLast.Anchor")));
			this.RemoveLast.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("RemoveLast.BackgroundImage")));
			this.RemoveLast.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("RemoveLast.Dock")));
			this.RemoveLast.Enabled = ((bool)(resources.GetObject("RemoveLast.Enabled")));
			this.RemoveLast.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("RemoveLast.FlatStyle")));
			this.RemoveLast.Font = ((System.Drawing.Font)(resources.GetObject("RemoveLast.Font")));
			this.RemoveLast.Image = ((System.Drawing.Image)(resources.GetObject("RemoveLast.Image")));
			this.RemoveLast.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("RemoveLast.ImageAlign")));
			this.RemoveLast.ImageIndex = ((int)(resources.GetObject("RemoveLast.ImageIndex")));
			this.RemoveLast.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("RemoveLast.ImeMode")));
			this.RemoveLast.Location = ((System.Drawing.Point)(resources.GetObject("RemoveLast.Location")));
			this.RemoveLast.Name = "RemoveLast";
			this.RemoveLast.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("RemoveLast.RightToLeft")));
			this.RemoveLast.Size = ((System.Drawing.Size)(resources.GetObject("RemoveLast.Size")));
			this.RemoveLast.TabIndex = ((int)(resources.GetObject("RemoveLast.TabIndex")));
			this.RemoveLast.Text = resources.GetString("RemoveLast.Text");
			this.RemoveLast.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("RemoveLast.TextAlign")));
			this.RemoveLast.Visible = ((bool)(resources.GetObject("RemoveLast.Visible")));
			this.RemoveLast.Click += new System.EventHandler(this.RemoveLast_Click);
			// 
			// tabControl1
			// 
			this.tabControl1.AccessibleDescription = resources.GetString("tabControl1.AccessibleDescription");
			this.tabControl1.AccessibleName = resources.GetString("tabControl1.AccessibleName");
			this.tabControl1.Alignment = ((System.Windows.Forms.TabAlignment)(resources.GetObject("tabControl1.Alignment")));
			this.tabControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabControl1.Anchor")));
			this.tabControl1.Appearance = ((System.Windows.Forms.TabAppearance)(resources.GetObject("tabControl1.Appearance")));
			this.tabControl1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabControl1.BackgroundImage")));
			this.tabControl1.Controls.Add(this.tabParserMessage);
			this.tabControl1.Controls.Add(this.tabOclHelp);
			this.tabControl1.Controls.Add(this.tabOclInfo);
			this.tabControl1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabControl1.Dock")));
			this.tabControl1.Enabled = ((bool)(resources.GetObject("tabControl1.Enabled")));
			this.tabControl1.Font = ((System.Drawing.Font)(resources.GetObject("tabControl1.Font")));
			this.tabControl1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabControl1.ImeMode")));
			this.tabControl1.ItemSize = ((System.Drawing.Size)(resources.GetObject("tabControl1.ItemSize")));
			this.tabControl1.Location = ((System.Drawing.Point)(resources.GetObject("tabControl1.Location")));
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.Padding = ((System.Drawing.Point)(resources.GetObject("tabControl1.Padding")));
			this.tabControl1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabControl1.RightToLeft")));
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.ShowToolTips = ((bool)(resources.GetObject("tabControl1.ShowToolTips")));
			this.tabControl1.Size = ((System.Drawing.Size)(resources.GetObject("tabControl1.Size")));
			this.tabControl1.TabIndex = ((int)(resources.GetObject("tabControl1.TabIndex")));
			this.tabControl1.Text = resources.GetString("tabControl1.Text");
			this.tabControl1.Visible = ((bool)(resources.GetObject("tabControl1.Visible")));
			// 
			// tabParserMessage
			// 
			this.tabParserMessage.AccessibleDescription = resources.GetString("tabParserMessage.AccessibleDescription");
			this.tabParserMessage.AccessibleName = resources.GetString("tabParserMessage.AccessibleName");
			this.tabParserMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabParserMessage.Anchor")));
			this.tabParserMessage.AutoScroll = ((bool)(resources.GetObject("tabParserMessage.AutoScroll")));
			this.tabParserMessage.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabParserMessage.AutoScrollMargin")));
			this.tabParserMessage.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabParserMessage.AutoScrollMinSize")));
			this.tabParserMessage.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabParserMessage.BackgroundImage")));
			this.tabParserMessage.Controls.Add(this.richTextBox1);
			this.tabParserMessage.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabParserMessage.Dock")));
			this.tabParserMessage.Enabled = ((bool)(resources.GetObject("tabParserMessage.Enabled")));
			this.tabParserMessage.Font = ((System.Drawing.Font)(resources.GetObject("tabParserMessage.Font")));
			this.tabParserMessage.ImageIndex = ((int)(resources.GetObject("tabParserMessage.ImageIndex")));
			this.tabParserMessage.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabParserMessage.ImeMode")));
			this.tabParserMessage.Location = ((System.Drawing.Point)(resources.GetObject("tabParserMessage.Location")));
			this.tabParserMessage.Name = "tabParserMessage";
			this.tabParserMessage.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabParserMessage.RightToLeft")));
			this.tabParserMessage.Size = ((System.Drawing.Size)(resources.GetObject("tabParserMessage.Size")));
			this.tabParserMessage.TabIndex = ((int)(resources.GetObject("tabParserMessage.TabIndex")));
			this.tabParserMessage.Text = resources.GetString("tabParserMessage.Text");
			this.tabParserMessage.ToolTipText = resources.GetString("tabParserMessage.ToolTipText");
			this.tabParserMessage.Visible = ((bool)(resources.GetObject("tabParserMessage.Visible")));
			// 
			// richTextBox1
			// 
			this.richTextBox1.AccessibleDescription = resources.GetString("richTextBox1.AccessibleDescription");
			this.richTextBox1.AccessibleName = resources.GetString("richTextBox1.AccessibleName");
			this.richTextBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("richTextBox1.Anchor")));
			this.richTextBox1.AutoSize = ((bool)(resources.GetObject("richTextBox1.AutoSize")));
			this.richTextBox1.BackColor = System.Drawing.SystemColors.Control;
			this.richTextBox1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("richTextBox1.BackgroundImage")));
			this.richTextBox1.BulletIndent = ((int)(resources.GetObject("richTextBox1.BulletIndent")));
			this.richTextBox1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("richTextBox1.Dock")));
			this.richTextBox1.Enabled = ((bool)(resources.GetObject("richTextBox1.Enabled")));
			this.richTextBox1.Font = ((System.Drawing.Font)(resources.GetObject("richTextBox1.Font")));
			this.richTextBox1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("richTextBox1.ImeMode")));
			this.richTextBox1.Location = ((System.Drawing.Point)(resources.GetObject("richTextBox1.Location")));
			this.richTextBox1.MaxLength = ((int)(resources.GetObject("richTextBox1.MaxLength")));
			this.richTextBox1.Multiline = ((bool)(resources.GetObject("richTextBox1.Multiline")));
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.ReadOnly = true;
			this.richTextBox1.RightMargin = ((int)(resources.GetObject("richTextBox1.RightMargin")));
			this.richTextBox1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("richTextBox1.RightToLeft")));
			this.richTextBox1.ScrollBars = ((System.Windows.Forms.RichTextBoxScrollBars)(resources.GetObject("richTextBox1.ScrollBars")));
			this.richTextBox1.Size = ((System.Drawing.Size)(resources.GetObject("richTextBox1.Size")));
			this.richTextBox1.TabIndex = ((int)(resources.GetObject("richTextBox1.TabIndex")));
			this.richTextBox1.Text = resources.GetString("richTextBox1.Text");
			this.richTextBox1.Visible = ((bool)(resources.GetObject("richTextBox1.Visible")));
			this.richTextBox1.WordWrap = ((bool)(resources.GetObject("richTextBox1.WordWrap")));
			this.richTextBox1.ZoomFactor = ((float)(resources.GetObject("richTextBox1.ZoomFactor")));
			// 
			// tabOclHelp
			// 
			this.tabOclHelp.AccessibleDescription = resources.GetString("tabOclHelp.AccessibleDescription");
			this.tabOclHelp.AccessibleName = resources.GetString("tabOclHelp.AccessibleName");
			this.tabOclHelp.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabOclHelp.Anchor")));
			this.tabOclHelp.AutoScroll = ((bool)(resources.GetObject("tabOclHelp.AutoScroll")));
			this.tabOclHelp.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabOclHelp.AutoScrollMargin")));
			this.tabOclHelp.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabOclHelp.AutoScrollMinSize")));
			this.tabOclHelp.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabOclHelp.BackgroundImage")));
			this.tabOclHelp.Controls.Add(this.tbxNodeInfo);
			this.tabOclHelp.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabOclHelp.Dock")));
			this.tabOclHelp.Enabled = ((bool)(resources.GetObject("tabOclHelp.Enabled")));
			this.tabOclHelp.Font = ((System.Drawing.Font)(resources.GetObject("tabOclHelp.Font")));
			this.tabOclHelp.ImageIndex = ((int)(resources.GetObject("tabOclHelp.ImageIndex")));
			this.tabOclHelp.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabOclHelp.ImeMode")));
			this.tabOclHelp.Location = ((System.Drawing.Point)(resources.GetObject("tabOclHelp.Location")));
			this.tabOclHelp.Name = "tabOclHelp";
			this.tabOclHelp.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabOclHelp.RightToLeft")));
			this.tabOclHelp.Size = ((System.Drawing.Size)(resources.GetObject("tabOclHelp.Size")));
			this.tabOclHelp.TabIndex = ((int)(resources.GetObject("tabOclHelp.TabIndex")));
			this.tabOclHelp.Text = resources.GetString("tabOclHelp.Text");
			this.tabOclHelp.ToolTipText = resources.GetString("tabOclHelp.ToolTipText");
			this.tabOclHelp.Visible = ((bool)(resources.GetObject("tabOclHelp.Visible")));
			// 
			// tbxNodeInfo
			// 
			this.tbxNodeInfo.AccessibleDescription = resources.GetString("tbxNodeInfo.AccessibleDescription");
			this.tbxNodeInfo.AccessibleName = resources.GetString("tbxNodeInfo.AccessibleName");
			this.tbxNodeInfo.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tbxNodeInfo.Anchor")));
			this.tbxNodeInfo.AutoSize = ((bool)(resources.GetObject("tbxNodeInfo.AutoSize")));
			this.tbxNodeInfo.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tbxNodeInfo.BackgroundImage")));
			this.tbxNodeInfo.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tbxNodeInfo.Dock")));
			this.tbxNodeInfo.Enabled = ((bool)(resources.GetObject("tbxNodeInfo.Enabled")));
			this.tbxNodeInfo.Font = ((System.Drawing.Font)(resources.GetObject("tbxNodeInfo.Font")));
			this.tbxNodeInfo.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tbxNodeInfo.ImeMode")));
			this.tbxNodeInfo.Location = ((System.Drawing.Point)(resources.GetObject("tbxNodeInfo.Location")));
			this.tbxNodeInfo.MaxLength = ((int)(resources.GetObject("tbxNodeInfo.MaxLength")));
			this.tbxNodeInfo.Multiline = ((bool)(resources.GetObject("tbxNodeInfo.Multiline")));
			this.tbxNodeInfo.Name = "tbxNodeInfo";
			this.tbxNodeInfo.PasswordChar = ((char)(resources.GetObject("tbxNodeInfo.PasswordChar")));
			this.tbxNodeInfo.ReadOnly = true;
			this.tbxNodeInfo.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tbxNodeInfo.RightToLeft")));
			this.tbxNodeInfo.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("tbxNodeInfo.ScrollBars")));
			this.tbxNodeInfo.Size = ((System.Drawing.Size)(resources.GetObject("tbxNodeInfo.Size")));
			this.tbxNodeInfo.TabIndex = ((int)(resources.GetObject("tbxNodeInfo.TabIndex")));
			this.tbxNodeInfo.Text = resources.GetString("tbxNodeInfo.Text");
			this.tbxNodeInfo.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("tbxNodeInfo.TextAlign")));
			this.tbxNodeInfo.Visible = ((bool)(resources.GetObject("tbxNodeInfo.Visible")));
			this.tbxNodeInfo.WordWrap = ((bool)(resources.GetObject("tbxNodeInfo.WordWrap")));
			// 
			// tabOclInfo
			// 
			this.tabOclInfo.AccessibleDescription = resources.GetString("tabOclInfo.AccessibleDescription");
			this.tabOclInfo.AccessibleName = resources.GetString("tabOclInfo.AccessibleName");
			this.tabOclInfo.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabOclInfo.Anchor")));
			this.tabOclInfo.AutoScroll = ((bool)(resources.GetObject("tabOclInfo.AutoScroll")));
			this.tabOclInfo.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabOclInfo.AutoScrollMargin")));
			this.tabOclInfo.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabOclInfo.AutoScrollMinSize")));
			this.tabOclInfo.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabOclInfo.BackgroundImage")));
			this.tabOclInfo.Controls.Add(this.textBox1);
			this.tabOclInfo.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabOclInfo.Dock")));
			this.tabOclInfo.Enabled = ((bool)(resources.GetObject("tabOclInfo.Enabled")));
			this.tabOclInfo.Font = ((System.Drawing.Font)(resources.GetObject("tabOclInfo.Font")));
			this.tabOclInfo.ImageIndex = ((int)(resources.GetObject("tabOclInfo.ImageIndex")));
			this.tabOclInfo.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabOclInfo.ImeMode")));
			this.tabOclInfo.Location = ((System.Drawing.Point)(resources.GetObject("tabOclInfo.Location")));
			this.tabOclInfo.Name = "tabOclInfo";
			this.tabOclInfo.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabOclInfo.RightToLeft")));
			this.tabOclInfo.Size = ((System.Drawing.Size)(resources.GetObject("tabOclInfo.Size")));
			this.tabOclInfo.TabIndex = ((int)(resources.GetObject("tabOclInfo.TabIndex")));
			this.tabOclInfo.Text = resources.GetString("tabOclInfo.Text");
			this.tabOclInfo.ToolTipText = resources.GetString("tabOclInfo.ToolTipText");
			this.tabOclInfo.Visible = ((bool)(resources.GetObject("tabOclInfo.Visible")));
			// 
			// textBox1
			// 
			this.textBox1.AccessibleDescription = resources.GetString("textBox1.AccessibleDescription");
			this.textBox1.AccessibleName = resources.GetString("textBox1.AccessibleName");
			this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("textBox1.Anchor")));
			this.textBox1.AutoSize = ((bool)(resources.GetObject("textBox1.AutoSize")));
			this.textBox1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("textBox1.BackgroundImage")));
			this.textBox1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("textBox1.Dock")));
			this.textBox1.Enabled = ((bool)(resources.GetObject("textBox1.Enabled")));
			this.textBox1.Font = ((System.Drawing.Font)(resources.GetObject("textBox1.Font")));
			this.textBox1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("textBox1.ImeMode")));
			this.textBox1.Location = ((System.Drawing.Point)(resources.GetObject("textBox1.Location")));
			this.textBox1.MaxLength = ((int)(resources.GetObject("textBox1.MaxLength")));
			this.textBox1.Multiline = ((bool)(resources.GetObject("textBox1.Multiline")));
			this.textBox1.Name = "textBox1";
			this.textBox1.PasswordChar = ((char)(resources.GetObject("textBox1.PasswordChar")));
			this.textBox1.ReadOnly = true;
			this.textBox1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("textBox1.RightToLeft")));
			this.textBox1.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("textBox1.ScrollBars")));
			this.textBox1.Size = ((System.Drawing.Size)(resources.GetObject("textBox1.Size")));
			this.textBox1.TabIndex = ((int)(resources.GetObject("textBox1.TabIndex")));
			this.textBox1.Text = resources.GetString("textBox1.Text");
			this.textBox1.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("textBox1.TextAlign")));
			this.textBox1.Visible = ((bool)(resources.GetObject("textBox1.Visible")));
			this.textBox1.WordWrap = ((bool)(resources.GetObject("textBox1.WordWrap")));
			// 
			// OclEditor
			// 
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.panel6);
			this.Controls.Add(this.splitter1);
			this.Controls.Add(this.panel3);
			this.Controls.Add(this.panel2);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximizeBox = false;
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimizeBox = false;
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "OclEditor";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.ShowInTaskbar = false;
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.Resize += new System.EventHandler(this.OclEditor_Resize);
			this.HelpRequested += new System.Windows.Forms.HelpEventHandler(this.OclEditor_HelpRequested);
			this.panel2.ResumeLayout(false);
			this.panel3.ResumeLayout(false);
			this.panel6.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.panel4.ResumeLayout(false);
			this.panel5.ResumeLayout(false);
			this.tabControl1.ResumeLayout(false);
			this.tabParserMessage.ResumeLayout(false);
			this.tabOclHelp.ResumeLayout(false);
			this.tabOclInfo.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		private IClassifier fContext;
		private IEcoTypeSystem fMDAModel;
		private ITypeService m_TypeService;
		private bool m_PsMode;
		private IExternalVariableList fVariables;

		//properties
		private ITypeService TypeService
		{
			set { m_TypeService = value; }
			get { return m_TypeService; }
		}

		private bool PsMode
		{
			get { return m_PsMode;}
			set { m_PsMode = value; }
		}
		
		private IClassifier Context
		{
			set { SetContext(value); }
			get { return fContext; }
		}

		private IEcoTypeSystem MDAModel
		{
			set { fMDAModel = value; }
			get { return fMDAModel; }
		}

		private string OclExpr
		{
			set { setOclExpr(value); }
			get { return getOclExpr(); }
		}

		private IExternalVariableList Variables
		{
			set { SetVariables(value); }
			get { return fVariables; }
		}
		private static string oclExpression;
		public static string OclExpression
		{
			get { return oclExpression; }
		}
		internal bool binOutOfDate;
		public static DialogResult ShowEditor(ITypeService typeService, IEcoTypeSystem typeSystem, IClassifier umlType, string oldExpression, IExternalVariableList variables)
		{
			return ShowEditor(typeService, typeSystem, umlType, oldExpression, variables, false);
		}
		public static OclEditor CurrentEditor()
		{
			return c_OclEditor;
		}
		private static OclEditor c_OclEditor;
		public static DialogResult ShowEditor(ITypeService typeService, IEcoTypeSystem typeSystem, IClassifier umlType, string oldExpression, IExternalVariableList variables, bool binariesOutOfDate)
		{
			c_OclEditor = new OclEditor();
			c_OclEditor.binOutOfDate = binariesOutOfDate;
			c_OclEditor.OclExpr = oldExpression;
			c_OclEditor.TypeService = typeService;
			c_OclEditor.PsMode = typeService is IOclPsTypeService;
			c_OclEditor.MDAModel = typeSystem;
			c_OclEditor.Variables = variables;
			c_OclEditor.Context = umlType;
			c_OclEditor.UpdateOptions();
			DialogResult dialogRes = DialogResult.OK;
			// there is something wrong in the handling of dialog results. If there is a syntaxerror, the dialog exits...
			oclExpression = string.Empty; // Clear the old expression before proceeding.
			dialogRes = c_OclEditor.ShowDialog();
			oclExpression = c_OclEditor.OclExpr;
			c_OclEditor.Dispose();
			c_OclEditor = null;
			return dialogRes;
		}

		private static IServiceProvider serviceProvider;
		///<exception cref="ArgumentNullException">Thrown if <paramref name="e"/> is null.</exception>
		public static bool ShowEditor(IServiceProvider serviceProvider, IHasEditableExpression e, bool binariesOutOfDate)
		{
			if (e == null) throw new ArgumentNullException("e"); // Do not localize
			OclEditor.serviceProvider = serviceProvider;
			ITypeService typeService = null;
			switch (e.ExpressionKind)
			{
				case ExpressionKind.Ocl:
					typeService = e.StaticContext.OclTypeService;
					break;
				case ExpressionKind.OclPs:
					typeService = e.StaticContext.OclPsTypeService;
					break;
				case ExpressionKind.EcoActionLanguage:
					typeService = e.StaticContext.ActionLanguageTypeService;
					break;
			}
			bool result = false;
			if (ShowEditor(typeService, e.StaticContext.TypeSystem, e.StaticContext.StaticUmlType, e.Expression, e.StaticContext.VariableList, binariesOutOfDate) == System.Windows.Forms.DialogResult.OK)
			{
				e.Expression = OclExpression;
				OclEditor.serviceProvider = null;
				result = true;
			}
			OclEditor.serviceProvider = null;
			return result;
		}
		public static bool ShowEditor(IHasEditableExpression e)
		{
			return ShowEditor(null, e, false);
		}

		private void CleanParserMsg()
		{
			richTextBox1.Text = string.Empty;
		}

		private void SetContext(IClassifier context)
		{
			String contextName = "<Model>";
			fContext = context;
			if (context != null )
				contextName = context.Name;
			if (TypeService is IOclTypeService)
				Text = FormsStringRes.sOclEditorCaptionWithContext(contextName);
			else if (TypeService is IActionLanguageTypeService)
				Text = FormsStringRes.sActionLanguageEditorCaptionWithContext(contextName);
			if (binOutOfDate)
				Text += " " + FormsStringRes.sNeedRecompile;

			UpdateOptions();
		}

		private void setOclExpr(string oclExpression)
		{
			int i;
			EditMemo.Text = oclExpression;
			i = EditMemo.Text.Length;
			if (i >= 2)
				EditMemo.SelectionStart = i - 2;
			UpdateOptions();
		}

		private const string _crlf = "\r\n";
		private const string _cr = "\r";

		private string getOclExpr()
		{
			int i;
			string result = string.Empty;
			for (i = 0; i <= EditMemo.Lines.Length - 1; i++)
			{
				result = result + EditMemo.Lines[i] + _cr;
				result = result.Remove(result.Length - 1, 1);
			}
			return result;
		}

		private void ShowError(string oclExpression, int errorpos, string message)
		{
			string expr = oclExpression.Replace(_crlf, _cr);
			richTextBox1.Text = expr + _crlf + _crlf + message;

			if (errorpos >= 0)
			{
				// compensate for error pos being calculated with crlf, but richtextbox only counts one character per new line
				string exprBeforeError = oclExpression.Substring(1, errorpos);
				string[] x = exprBeforeError.Split(new char[1]{'\r'});
				if (x.Length >= 2)
					errorpos = errorpos - (x.Length - 1);
				richTextBox1.SelectionStart = errorpos;

				char[] separators = new char[24]
				{
					'.', ':', '@', '|', ';', '\'', ',',
					' ', '\r',
					'*', '+', '-', '/', '=',
					'[', ']', '<', '>', '(', ')', '{', '}', '', ''
				};

				int endpos;
				if (expr[errorpos] == '')
					endpos = expr.IndexOf('', errorpos)+1;
				else if (expr.IndexOfAny(separators, errorpos) == errorpos)
				{
					// errorpos is a separator
					if ((expr.IndexOf(":=", errorpos) == errorpos) ||
						(expr.IndexOf("->", errorpos) == errorpos) ||
						(expr.IndexOf("::", errorpos) == errorpos))
						endpos = errorpos + 2;
					else
						endpos = errorpos + 1;

				}
				else
				{
					endpos = (expr+".").IndexOfAny(separators, errorpos+1);
				}
				if (endpos != -1 && endpos > errorpos)
					richTextBox1.SelectionLength = endpos - errorpos ;
				else
					richTextBox1.SelectionLength = 1;

//				KnownColor.HighlightText results in "white"
//				KnownColor.Highlight results in "pale blue"
				richTextBox1.SelectionColor = Color.FromKnownColor(KnownColor.Red);
				richTextBox1.SelectionFont = new Font(richTextBox1.SelectionFont, FontStyle.Bold);
			}
		}

		private string filterPrefix = String.Empty;

		private IClassifier CheckOcl(string oclExpression)
		{
			String typeName = FormsStringRes.sUnknown;
			IClassifier Result = null;

			CleanParserMsg();
			filterPrefix = String.Empty;

			if (oclExpression == null || oclExpression.Length == 0)
			{
				Result = Context;
				richTextBox1.Text = FormsStringRes.sEmptyExpression;
				return Result;
			}

			try
			{
				Result = TypeService.ExpressionType(oclExpression, Context, true, Variables);
			}
			catch (EcoOclErrorException e)
			{
				string trimmedExpr = AllButLast(oclExpression);
				filterPrefix = oclExpression.Substring(trimmedExpr.Length);
				Result = TypeService.ExpressionType(trimmedExpr, Context, false, Variables);

				string expression = e.Expression;
				if (e.InternalError)
					expression = FormsStringRes.sInternalOclError(expression);
				ShowError(e.Expression, e.Position, e.Message);
				return Result;
			}
			catch (Exception e)
			{
				Result = null;
				richTextBox1.Text = richTextBox1.Text + _crlf + e.ToString();
				return Result;
			}

			string message = FormsStringRes.sSyntaxIsOk;
			message += _crlf;
			if (Result != null)
				typeName = Result.Name;
			message += _crlf + FormsStringRes.sCurrentType(typeName);
			richTextBox1.Text = message;
			richTextBox1.SelectionStart = 0;
			richTextBox1.SelectionLength = 0;
			return Result;
		}

		private IOclTypeFactory TypeFactory
		{
			get { return TypeService as IOclTypeFactory; } // Sidecast.
		}

		private Hashtable nodeList = new Hashtable();
		private void OperationHelp(IClassifier expressionType, String oclExpression)
		{
			string[] prefix = {"->", "."};

			IOclType expressionOclType = null;
			if (expressionType != null)
			{
				expressionOclType = TypeFactory.TypeForClassifier(expressionType);
			}
			else if (MDAModel.GetClassifierByName(oclExpression) != null)
			{
				expressionOclType = TypeFactory.TypeType;
			}

			methodNode.Nodes.Clear();
			oclOperationNode.Nodes.Clear();
			triggerNode.Nodes.Clear();
			triggerQueryNode.Nodes.Clear();
			ArrayList methodNodes = new ArrayList();
			ArrayList triggerNodes = new ArrayList();
			ArrayList triggerQueryNodes = new ArrayList();
			ArrayList oclOperationNodes = new ArrayList();

			if (expressionOclType != null)
			{
				IOclOperation[] operations = TypeService.InstalledOclOperations;

				for (int i = 0; i < operations.Length; i++)
				{
					IOclOperation symbol = operations[i];
					IOclType t = expressionOclType;
					// make sure for example string-operations are valid for Collection(String)
					if (t.IsListType())
						t = t.ElementType;
					if (symbol.IsPostFix && t.ConformsTo(symbol.FormalParameters[0]) && !symbol.IsTypeOperation)
					{
						StringBuilder sb = new StringBuilder(prefix[symbol.IsDotNotation ? 1 : 0]);
						sb.Append(symbol.Name);

						if (symbol.FormalParameters.Length > 1)
						{
							sb.Append("(");
							bool first = true;
							for (int j = 1; j < symbol.FormalParameters.Length; j++)
							{
								if (j == (symbol.FormalParameters.Length-symbol.RepeatParameters))
								  sb.Append("["); // do not localize
								if (!first)
									sb.Append(", ");
								first = false;
								string paramType = symbol.FormalParameters[j].Name();
								if ((paramType.Substring(0, 1) == "<") && (paramType.Substring(paramType.Length - 2, 1) == ">"))
									paramType = paramType.Substring(1, paramType.Length - 2);
								sb.Append("");
								sb.Append(paramType.Replace(" ", "_"));
								sb.Append("");
							}
							if (symbol.RepeatParameters > 0)
								  sb.Append("...]"); // do not localize
							
							sb.Append(")");
						}

						string expr = sb.ToString();
						string text = expr;
						if (ShowTypes)
							text += ": " + symbol.ResultType.Name();

						if (MatchFilterPrefix(expr))
						{
							expr = expr.Substring(filterPrefix.Length);
							SelectBox.Items.Add(NewItem(OperationPrefix, text, expr));
							TreeNode node = NewNode(text, expr);
							nodeList.Add(node, symbol);

							if (symbol is OclMethod)
								methodNodes.Add(node);
							else if (symbol is OclTrigger)
								triggerNodes.Add(node);
							else if (symbol is OclTriggerQuery)
								triggerQueryNodes.Add(node);
							else
								oclOperationNodes.Add(node);
						}
					}
				}
			}
			AddSortedNodes(methodNode, methodNodes);
			AddSortedNodes(oclOperationNode, oclOperationNodes);
			AddSortedNodes(triggerNode, triggerNodes);
			AddSortedNodes(triggerQueryNode, triggerQueryNodes);
		}

		private bool MatchFilterPrefix(string expr)
		{
			return filterPrefix == String.Empty || expr.ToUpper(CultureInfo.InvariantCulture).StartsWith(filterPrefix.ToUpper(CultureInfo.InvariantCulture));
		}
		private bool ShowTypes
		{
			get { return tbbShowTypes.Pushed; }
		}
		private class NodeComparer: IComparer
		{
			int IComparer.Compare(object x, object y)
			{
				return String.Compare((x as TreeNode).Text, (y as TreeNode).Text);
			}
		}
		private class TagComparer: IComparer
		{
			int IComparer.Compare(object x, object y)
			{
				TreeNode xNode = x as TreeNode;
				TreeNode yNode = y as TreeNode;
				System.Diagnostics.Debug.Assert(xNode.Tag != null, "node " + xNode.Text + " has no tag");
				System.Diagnostics.Debug.Assert(yNode.Tag != null, "node " + yNode.Text + " has no tag");
				return (xNode.Tag as IComparable).CompareTo(yNode.Tag);
			}
		}
		private void SortSubnodes(TreeNode n)
		{
			ArrayList nodes = new ArrayList();
			nodes.AddRange(n.Nodes);
			nodes.Sort(new NodeComparer());
			n.Nodes.Clear();
			n.Nodes.AddRange((TreeNode[])(nodes.ToArray(typeof(TreeNode))));
			foreach (TreeNode subnode in n.Nodes)
				SortSubnodes(subnode);
		}

		private void AddSortedNodes(TreeNode parent, ArrayList nodes)
		{
			if (nodes.Count == 0)
			{
				if (SelectTree.Nodes.Contains(parent))
					SelectTree.Nodes.Remove(parent);
                parent.Collapse();
			}
			else
			{
				if (!SelectTree.Nodes.Contains(parent))
					SelectTree.Nodes.Add(parent);
				nodes.Sort(new NodeComparer());
				foreach (TreeNode n in nodes)
				{
					parent.Nodes.Add(n);
					n.SelectedImageIndex = parent.SelectedImageIndex;
					n.ImageIndex = parent.ImageIndex;
					SortSubnodes(n);
				}
			}
		}

		private void VariableHelp(IClassifier expressionType, string oclExpression)
		{
			variableNode.Nodes.Clear();
			ArrayList variableNodes = new ArrayList();
			if (Variables != null)
			{
				foreach (IExternalVariable v in Variables)
				{
					string name = v.Name;
					if (ShowTypes && v.StaticUmlType != null)
						name += ": " + v.StaticUmlType.Name;

					TreeNode node = NewNode(name, name, oclExpression != null && oclExpression.Length > 0);
					variableNodes.Add(node);
				}
			}
			AddSortedNodes(variableNode, variableNodes);
		}

		private bool Hierarchical { get { return tbbHierarchical.Pushed; }}

		private void MemberHelp(IClassifier expressionType, string oclExpression)
		{
			classNode.Nodes.Clear();
			attributeNode.Nodes.Clear();
			roleNode.Nodes.Clear();
			ArrayList classNodes = new ArrayList();
			ArrayList attributeNodes = new ArrayList();
			ArrayList roleNodes = new ArrayList();
			Hashtable allClasses = new Hashtable();
			TreeNode node;
			foreach (IClass c in MDAModel.AllClasses)
			{
				node = null;
				if (oclExpression == null || oclExpression.Length == 0)
					SelectBox.Items.Add(NewItem(ClassPrefix, c.Name, c.Name));
				if (c.EcoClass.Persistent || !PsMode)
				{
					if (filterPrefix == String.Empty && Hierarchical && c.EcoClass.SuperClass != null)
					{
						node = NewNode(c.Name, c.Name, oclExpression != String.Empty);
						TreeNode superNode = allClasses[c.EcoClass.SuperClass.Name] as TreeNode;
						superNode.Nodes.Add(node);
					}
					else
					{
						string expr = c.Name;
						if (MatchFilterPrefix(expr))
						{
							expr = expr.Substring(filterPrefix.Length);
							node = NewNode(c.Name, expr, oclExpression != String.Empty || oclExpression != filterPrefix);
							classNodes.Add(node);
						}
					}
					if (node != null)
						allClasses[c.Name] = node;
				}
			}

			if (expressionType != null)
			{
				expressionType = HandleUtils.ItemType(expressionType);

				if (expressionType != null && expressionType.ClassifierType == ClassifierType.Class)
				{
					IClass classInfo = expressionType as IClass;
					foreach (IStructuralFeature feature in classInfo.EcoClass.AllStructuralFeatures)
					{
						if (feature.EcoStructuralFeature.Persistent || !feature.EcoStructuralFeature.IsDerived || !PsMode)
						{
							IAttribute attribute = feature as IAttribute;
							if (attribute != null)
							{
								string expr = "." + attribute.Name;
								string text = expr;
								if (ShowTypes)
									text += ": " + attribute.Type_.Name;
								if (tbbShowDefiningClass.Pushed)
									text = attribute.Owner.Name + text;

								if (MatchFilterPrefix(expr))
								{
									expr = expr.Substring(filterPrefix.Length);
									SelectBox.Items.Add(NewItem(AttributePrefix, text, expr));
									attributeNodes.Add(NewNode(text.Trim(), expr));
								}
							}
							else if (feature is IAssociationEnd)
							{
								IAssociationEnd role = feature as IAssociationEnd;
								if (role.IsNavigable)
								{
									string expr = "." + role.Name;
									string text = expr;
									if (ShowTypes)
									{
										if ((role.Multiplicity.Upper > 1) || role.Multiplicity.IsUnbounded)
											text += ": List<" + role.Type_.Name + ">";
										else
											text += ": " + role.Type_.Name;
									}
									if (tbbShowDefiningClass.Pushed)
										text = role.Owner.Name + text;
									if (MatchFilterPrefix(expr))
									{
										expr = expr.Substring(filterPrefix.Length);
										SelectBox.Items.Add(NewItem(RolePrefix, text, expr));
										roleNodes.Add(NewNode(text.Trim(), expr));
									}
								}
							}
						}
					}
				}
			}
			AddSortedNodes(classNode, classNodes);
			AddSortedNodes(attributeNode, attributeNodes);
			AddSortedNodes(roleNode, roleNodes);
		}

		private void UpdateTreeNodeOrder()
		{
			ArrayList nodes = new ArrayList();
			foreach (TreeNode t in SelectTree.Nodes)
				nodes.Add(t);
			nodes.Sort(new TagComparer());
			SelectTree.Nodes.Clear();
			foreach (TreeNode t in nodes)
				SelectTree.Nodes.Add(t);
		}

		private void UpdateOptions()
		{
			if (TypeService == null)
			{
				richTextBox1.Text = FormsStringRes.sNoContext;
				return;
			}

			SelectBox.Items.Clear();
			if (!MDAModel.IsBrowsable)
			{
				string s = FormsStringRes.sInvalidModel +_crlf +
					MDAModel.NonRunnableReason;

				richTextBox1.Text = s;
			}
			else
			{
				string oclExpression = EditMemo.Text.Trim();

				IClassifier expressionType = CheckOcl(oclExpression);

				SelectBox.BeginUpdate();
				SelectTree.BeginUpdate();
				try
				{
					MemberHelp(expressionType, oclExpression);
					OperationHelp(expressionType, oclExpression);
					VariableHelp(expressionType, oclExpression);

					Sort(SelectBox.Items);
					UpdateTreeNodeOrder();
					int nodeCount = 0;
					foreach (TreeNode n in SelectTree.Nodes)
					{
						nodeCount += n.Nodes.Count+1;
					}
					if (filterPrefix != String.Empty && nodeCount <= SelectTree.VisibleCount)
						SelectTree.ExpandAll();

					if (nodeCount == 2)
						SelectTree.SelectedNode = SelectTree.Nodes[0].Nodes[0];

				}

				finally
				{
					SelectTree.EndUpdate();
					SelectBox.EndUpdate();
				}
			}
		}

		private static void Sort(System.Windows.Forms.ListBox.ObjectCollection collection)
		{
			ArrayList y = new ArrayList(collection);
			y.Sort(Comparer.Default);
			collection.Clear();
			foreach(Object x in y)
				collection.Add(x);
		}

		private void Clear_Click(object sender, System.EventArgs e)
		{
			EditMemo.Clear();
			UpdateOptions();
		}

		private string AllButLast(string expr)
		{
			// rewrite this entire procedure...

			string line = expr.Trim();
			if (line != null && line.Length > 0)
			{
				int p = -1;
				p = Math.Max(p, line.LastIndexOf('('));
				p = Math.Max(p, line.LastIndexOf('.'));
				p = Math.Max(p, line.LastIndexOf(' '));
				p = Math.Max(p, line.LastIndexOf("->"));
				if (p != -1)
				{
					line = line.Remove(p, line.Length - p);
					line = line.Trim();
				}
				else
				{
					line = string.Empty;
				}
			}
			return line;
		}

		private void RemoveLast_Click(object sender, System.EventArgs e)
		{
			EditMemo.Text = AllButLast(EditMemo.Text);
		}

		private void SetSelection()
		{
			int i, j;
			if (EditMemo.SelectionLength == 0)
			{
				i = EditMemo.SelectionStart - 1;
				while ((i > 0) && !((EditMemo.Text[i] == '') || (EditMemo.Text[i] == '')))
					i--;

				if ((i <= 0)|| (EditMemo.Text[i] == ''))
					return;

				j = i + 1;
				while ((j < (EditMemo.Text.Length)) && !((EditMemo.Text[j] == '' || (EditMemo.Text[j] == ''))))
					j++;

				if ((j >= EditMemo.Text.Length) || (EditMemo.Text[j] == ''))
					return;

				if (i >= 0)
					EditMemo.SelectionStart = i;
				EditMemo.SelectionLength = j - i + 1;
			}
		}

		private void SetVariables(IExternalVariableList Value)
		{
			fVariables = Value;
			UpdateOptions();
		}

		private void SelectBox_DoubleClick(object sender, System.EventArgs e)
		{
			if (SelectBox.Items.Count > 0)
			{
				if (SelectBox.SelectedIndex == -1)
					SelectBox.SelectedIndex = 0;
				ListItem item = (ListItem)SelectBox.Items[SelectBox.SelectedIndex];
				string expr =item.Expr;

				if ((EditMemo.Text.Length == 0) && (expr.StartsWith("->") || expr.StartsWith(".")))
					expr = "self" + expr;

				EditMemo.Text = EditMemo.Text + expr;

				UpdateOptions();
			}
		}

		private void EditMemo_Enter(object sender, System.EventArgs e)
		{
			UpdateOptions();
		}

		private void SelectBox_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if (e.KeyChar == _cr[0])
				SelectBox_DoubleClick(sender, e);
		}

		private void EditMemo_TextChanged(object sender, System.EventArgs e)
		{
			UpdateOptions();
		}

		private void EditMemo_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			SetSelection();
		}

		private void EditMemo_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			SetSelection();
//			if (e.KeyChar == _esc[0] )
//			{
//				DialogResult = DialogResult.Cancel;
//			}
			// when the user presses enter and has a node selected in the treeview
			// we simulate a doubleclick and move the cursor to the last character.
			if ((e.KeyChar == (char)13) && SelectTree.SelectedNode != null && SelectTree.Visible)
			{
				e.Handled = true;
				SelectTree_DoubleClick(null, null);
				EditMemo.SelectionStart = Int32.MaxValue;
			}

		}

		private void OK_Click(object sender, System.EventArgs e)
		{
			DialogResult = DialogResult.OK;
		}

		private void Cancel_Click(object sender, System.EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
		}

		private void EditMemo_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			SetSelection();
		}

		private void SelectBox_DrawItem(object sender, System.Windows.Forms.DrawItemEventArgs e)
		{
			PointF Point;
			System.Drawing.Brush drawBrush;

			e.DrawBackground();
			if (e.Index != -1 )
			{
				ListItem item = (ListItem)SelectBox.Items[e.Index];
				int index=0;
				switch (item.Prefix)
				{
					case AttributePrefix: index = 0; break;
					case ClassPrefix: index = 1; break;
					case RolePrefix: index = 2; break;
					case UnknownPrefix: index = 3; break;
					case OperationPrefix: index = 4; break;
				}
				imageList1.Draw(e.Graphics,e.Bounds.X,e.Bounds.Y,16,16,index);

				Point = new Point(e.Bounds.X + 16, e.Bounds.Y);

				if (SelectBox.SelectedIndex == e.Index)
					drawBrush = System.Drawing.SystemBrushes.HighlightText;
				else
					drawBrush = System.Drawing.SystemBrushes.WindowText;
				e.Graphics.DrawString(item.Text, e.Font, drawBrush, Point);
			}
		}
		private void SelectBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SelectBox.Invalidate();
		}

		private void OclEditor_HelpRequested(object sender, System.Windows.Forms.HelpEventArgs hlpevent)
		{
			if (serviceProvider == null) return;

			IHelpService helpService = (IHelpService)serviceProvider.GetService(typeof(IHelpService));
			if (helpService != null)
				helpService.ShowHelpFromKeyword(HelpHelpers.hcOCLEditor);

/*			if (Site != null)
			{
				IHelpService helpService = (IHelpService) Site.GetService(typeof(IHelpService));
				if (helpService != null)
					helpService.ShowHelpFromKeyword(HelpHelpers.hcOCLEditor);
			}
			*/
		}

		private void SelectBox_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (e.Button != MouseButtons.None)
				SelectBox.Refresh();
		}

		private void splitter1_SplitterMoved(object sender, System.Windows.Forms.SplitterEventArgs e)
		{
			tabControl1.Width = EditMemo.Width;
//			const Int32 leftSideWidth = 88 + 88 + 4 + 4 + 4;
//			if (splitter1.Left < leftSideWidth)
//				panel3.Left = this.Width - leftSideWidth;
		}

		const Int32 leftSideWidth = 88 + 88 + 4 + 4 + 4 + 8 + 8;
		private void panel3_Resize(object sender, System.EventArgs e)
		{
			if (panel3.Left < leftSideWidth)
				panel3.Width = this.Width - leftSideWidth;
		}

		private void OclEditor_Resize(object sender, System.EventArgs e)
		{
			if (panel3.Left < leftSideWidth)
				panel3.Width = this.Width - leftSideWidth;
		}

		private void SelectTree_DoubleClick(object sender, System.EventArgs e)
		{
			if (SelectTree.SelectedNode != null &&
				SelectTree.SelectedNode.Parent != null)
			{
				string Addition = (string)SelectTree.SelectedNode.Tag;

/*				Addition = Addition.TrimStart();
				if (Addition.IndexOf(" ")>0)
					Addition = Addition.Substring( 0, Addition.IndexOf(" "));

				if (Addition.IndexOf(":") == Addition.Length - 1)
					Addition = Addition.Substring(0, Addition.Length - 1);
*/
				// Prefix with 'self' if at start of expression
				if ((EditMemo.Text.Length == 0) && (Addition.StartsWith("->") || Addition.StartsWith(".")))
					Addition = "self" + Addition;

				// Avoid double dots
				if (Addition.StartsWith(".") && EditMemo.Text.EndsWith("."))
					Addition = Addition.Substring(1);

				EditMemo.Text = EditMemo.Text + Addition;

				UpdateOptions();
			}
		}

		private void EnableTreeView(bool value)
		{
			SelectBox.Visible = !value;
			SelectTree.Visible = value;
			treeviewVisible = value;
			tbbHierarchical.Enabled = value;
		}

		private void toolBar1_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if (e.Button == tbbList)
				EnableTreeView(!tbbList.Pushed);
			else if (e.Button == tbbShowTypes || e.Button == tbbHierarchical || e.Button == tbbShowDefiningClass)
			{
				int oldIndex = SelectBox.SelectedIndex;
				int oldTop = SelectBox.TopIndex;
				UpdateOptions();
				SelectBox.SelectedIndex = oldIndex;
				SelectBox.TopIndex = oldTop;
			}
		}
		private string OperationHelpString(IOclOperation operation)
		{
			if (operation == null) return string.Empty;

			EcoOclOperationResourcedHelpAttribute oclResourceHelpAttribute = Attribute.GetCustomAttribute(operation.GetType(), typeof(EcoOclOperationResourcedHelpAttribute)) as EcoOclOperationResourcedHelpAttribute;
			if (oclResourceHelpAttribute != null)
				return oclResourceHelpAttribute.HelpString(operation);

			// Then look for an attribute specifying the actual help string
			EcoOclOperationHelpAttribute oclHelpAttribute = Attribute.GetCustomAttribute(operation.GetType(), typeof(EcoOclOperationHelpAttribute)) as EcoOclOperationHelpAttribute;
			if (oclHelpAttribute != null)
				return oclHelpAttribute.HelpString;

			// No luck. Return empty string.
			return string.Empty;
		}

		private void SelectTree_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			IOclOperation oclOperation = nodeList[e.Node] as IOclOperation;
			tbxNodeInfo.Text = OperationHelpString(oclOperation);
		}

		private void splitter2_SplitterMoved(object sender, System.Windows.Forms.SplitterEventArgs e)
		{
			EditMemo.Height = splitter2.Top - 4;
			tabControl1.Height = panel5.Height - tabControl1.Top;
		}
		
		private void SelectTree_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
 			if (e.KeyChar == _cr[0])
				SelectTree_DoubleClick(sender, e);
		}
	}

}
